/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import me.towdium.pinin.Keyboard;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class JechConfig {
    public static final String PATH = "jecharacters.toml";
    public static ForgeConfigSpec common;
    public static ForgeConfigSpec.BooleanValue enableQuote;
    public static ForgeConfigSpec.EnumValue<Spell> enumKeyboard;
    public static ForgeConfigSpec.BooleanValue enableFZh2z;
    public static ForgeConfigSpec.BooleanValue enableFSh2s;
    public static ForgeConfigSpec.BooleanValue enableFCh2c;
    public static ForgeConfigSpec.BooleanValue enableFAng2an;
    public static ForgeConfigSpec.BooleanValue enableFIng2in;
    public static ForgeConfigSpec.BooleanValue enableFEng2en;
    public static ForgeConfigSpec.BooleanValue enableFU2v;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> listDumpClass;
    public static ForgeConfigSpec.BooleanValue enableVerbose;
    public static ForgeConfigSpec.BooleanValue enableChat;

    static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, common, FMLPaths.CONFIGDIR.get().resolve(PATH).toString());
    }

    static {
        Predicate<Object> p = i -> i instanceof String;
        ForgeConfigSpec.Builder b = new ForgeConfigSpec.Builder();
        b.push("General");
        b.comment("Keyboard for the checker to use");
        enumKeyboard = b.defineEnum("enumKeyboard", (Enum)Spell.QUANPIN);
        b.comment("Set to true to enable fuzzy spelling zh <=> z");
        enableFZh2z = b.define("enableFZh2z", false);
        b.comment("Set to true to enable fuzzy spelling sh <=> s");
        enableFSh2s = b.define("enableFSh2s", false);
        b.comment("Set to true to enable fuzzy spelling ch <=> c");
        enableFCh2c = b.define("enableFCh2c", false);
        b.comment("Set to true to enable fuzzy spelling ang <=> an");
        enableFAng2an = b.define("enableFAng2an", false);
        b.comment("Set to true to enable fuzzy spelling ing <=> in");
        enableFIng2in = b.define("enableFIng2in", false);
        b.comment("Set to true to enable fuzzy spelling eng <=> en");
        enableFEng2en = b.define("enableFEng2en", false);
        b.comment("Set to true to enable fuzzy spelling u <=> v");
        enableFU2v = b.define("enableFU2v", false);
        b.comment("Set to false to disable chat message when entering world");
        enableChat = b.define("enableChat", true);
        b.comment("Set to true to disable JEI's split for search tokens");
        enableQuote = b.define("enableQuote", false);
        b.pop();
        b.push("Utilities");
        b.comment("List of classes to dump all the functions");
        listDumpClass = b.defineList("listDumpClass", Collections.emptyList(), p);
        b.comment("Set true to print verbose debug message");
        enableVerbose = b.define("enableVerbose", false);
        b.pop();
        common = b.build();
    }

    public static enum Spell {
        QUANPIN(Keyboard.QUANPIN),
        DAQIAN(Keyboard.DAQIAN),
        XIAOHE(Keyboard.XIAOHE),
        ZIRANMA(Keyboard.ZIRANMA);

        public final Keyboard keyboard;

        private Spell(Keyboard keyboard) {
            this.keyboard = keyboard;
        }

        Keyboard get() {
            return this.keyboard;
        }
    }
}

